/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.HardwareEvent15Rule;
import com.ibm.hwmca.base.pa.ar.HardwareEvent15RuleBase;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class HardwareEvent15XMLParser
extends CommonXMLParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XPALXMLT";
    private static final String TRACE_MASKF = "XPALXMLF";
    private static final String TRACE_MASKD = "XPALXMLD";
    private static final String TAG_HER_RULEBASE = "Hde-rulebase";
    private static final String TAG_HER_RULE = "Hde-rule";
    private static final String TAG_EXTENSION = "EXTENSION";
    private static final String TAG_EXTENSION_DATA = "EXTENSION_DATA";
    private static final String TAG_PRIORITY = "PRIORITY";
    private static final String TAG_SERVICE = "SERVICE";
    private static final String TAG_TRANSMIT = "TRANSMIT";
    private static final String TAG_REFCODE = "REFCODE";
    private static final String TAG_MESSAGES = "MESSAGES";
    private static final String TAG_TXTFLDS = "TXTFLDS";
    private static final String TAG_TYPEID = "TYPEID";
    private static final String TAG_RETURN_CODE = "RETURN_CODE";
    private static final String TAG_TRUE = "TRUE";
    public static final String RULEBASE_ISC = "rulebase_isc.xml";
    public static final String RULEBASE_ESCON = "/home/wmdovin/javahmc/linuxhmc/data/pa/test.xml";

    public HardwareEvent15XMLParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKD, "HardwareEvent15XMLParser.ctor");
    }

    public static HardwareEvent15RuleBase parseXML(String fileName) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "HardwareEvent15XMLParser.parseXML(" + fileName + ")");
        return HardwareEvent15XMLParser.parseXML(new File(fileName));
    }

    public static HardwareEvent15RuleBase parseXML(File file) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "HardwareEventXMLParser.parseXML(" + file + ")");
        try {
            HardwareEvent15XMLParser parser = new HardwareEvent15XMLParser();
            if (parser != null) {
                Trace.trace(TRACE_MASKD, "acquired parser next open file " + file);
            } else {
                Trace.trace(TRACE_MASKD, "could not acquired parser");
            }
            InputSource xmlSource = new InputSource(new FileInputStream(file));
            if (xmlSource != null) {
                Trace.trace(TRACE_MASKD, "have a file");
            } else {
                Trace.trace(TRACE_MASKD, "could not acquired file");
            }
            parser.parse(xmlSource);
            Trace.trace(TRACE_MASKD, "parser.parse file");
            Document doc = parser.getDocument();
            if (doc != null) {
                Trace.trace(TRACE_MASKD, "got the Document");
            } else {
                Trace.trace(TRACE_MASKD, "no Document");
            }
            NodeList root = doc.getElementsByTagName(TAG_HER_RULEBASE);
            Trace.trace(TRACE_MASKD, "nodelist length" + root.getLength());
            HardwareEvent15RuleBase rb = null;
            if (root.getLength() != 1) {
                Trace.trace(TRACE_MASKD, "too many Nodes");
                throw new MalformedXMLException("A single <Hde-rulebase> is expected.");
            }
            rb = HardwareEvent15XMLParser.parseRulebase(root.item(0));
            return rb;
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException reading file");
        }
        catch (ClassNotFoundException e) {
            throw new MalformedXMLException("ClassNotFoundException!");
        }
        catch (SAXParseException e) {
            throw new MalformedXMLException("SaxParseException! " + HardwareEvent15XMLParser.where(e));
        }
        catch (SAXException e) {
            throw new MalformedXMLException("SaxException! " + e);
        }
    }

    private static HardwareEvent15RuleBase parseRulebase(Node node) throws ClassNotFoundException, MalformedXMLException {
        HardwareEvent15RuleBase rb = new HardwareEvent15RuleBase();
        NodeList children = node.getChildNodes();
        Trace.trace(TRACE_MASKD, "Children nodelist length = " + children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            Trace.trace(TRACE_MASKD, "child element node = " + child.getNodeType() + " child value =" + child.getNodeValue() + " child name =" + child.getNodeName());
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().toLowerCase().equals(TAG_HER_RULE.toLowerCase())) {
                rb.addRule(HardwareEvent15XMLParser.parseRule(child));
                Trace.trace(TRACE_MASKD, "Added rule");
                continue;
            }
            Trace.trace(TRACE_MASKD, "Error parsing HardwareEventRuleBase");
            throw new MalformedXMLException("Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        return rb;
    }

    private static HardwareEvent15Rule parseRule(Node node) throws ClassNotFoundException, MalformedXMLException {
        HardwareEvent15Rule rule = new HardwareEvent15Rule();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals(TAG_PRIORITY)) {
                rule.setPriority(HardwareEvent15XMLParser.gatherTextContents(child));
                Trace.trace(TRACE_MASKD, "set This rule priority with " + HardwareEvent15XMLParser.gatherTextContents(child));
                continue;
            }
            if (child.getNodeName().equals(TAG_SERVICE)) {
                rule.setService(HardwareEvent15XMLParser.gatherTextContents(child));
                Trace.trace(TRACE_MASKD, "set This rule service with " + HardwareEvent15XMLParser.gatherTextContents(child));
                continue;
            }
            if (child.getNodeName().equals(TAG_MESSAGES)) {
                Trace.trace(TRACE_MASKD, "set messages with " + HardwareEvent15XMLParser.gatherTextContents(child));
                rule.setMessages(HardwareEvent15XMLParser.gatherTextContents(child));
                continue;
            }
            if (child.getNodeName().equals(TAG_REFCODE)) {
                Trace.trace(TRACE_MASKD, "set RefCode with " + HardwareEvent15XMLParser.gatherTextContents(child));
                rule.setRefCode(HardwareEvent15XMLParser.getArrayListOfRefCodes(HardwareEvent15XMLParser.gatherTextContents(child)));
                continue;
            }
            Trace.trace(TRACE_MASKD, "Unknown tage in rule which is to be expected = ");
        }
        Trace.trace(TRACE_MASKD, "about to set rule.key");
        return rule;
    }

    private static ArrayList getArrayListOfRefCodes(String refCodeStr) {
        Trace.trace(TRACE_MASKD, "-->in getArrayListOfMessages " + refCodeStr);
        ArrayList<String> returnList = new ArrayList<String>();
        boolean finished = false;
        int i = 0;
        int comma = 0;
        refCodeStr = refCodeStr.trim();
        while (!finished) {
            comma = refCodeStr.indexOf(",", i);
            if (comma == -1) {
                finished = true;
                Trace.trace(TRACE_MASKD, "refCode Added " + refCodeStr.trim().substring(i + 1, refCodeStr.length() - 1));
                returnList.add(refCodeStr.trim().substring(i + 1, refCodeStr.length() - 1));
                continue;
            }
            Trace.trace(TRACE_MASKD, "refCode Being Added " + refCodeStr.trim().substring(i + 1, comma - 1));
            returnList.add(refCodeStr.trim().substring(i + 1, comma - 1));
            refCodeStr = refCodeStr.substring(comma + 1).trim();
            Trace.trace(TRACE_MASKD, "refCodeStr =  " + refCodeStr);
        }
        Trace.trace(TRACE_MASKD, "<-- getArrayListOfMessages " + returnList.size());
        return returnList;
    }
}

